package gov.va.vinci.dart.json;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="Reviews")
@XmlType(name="Reviews", propOrder={
		"trackingNumber",
		"dateRange",
		"displayTotals",
		"totalDaysElapsed",
		"totalMedianDaysElapsed",
		"totalRequestorDaysElapsed",
		"totalRequestorMedianDaysElapsed",
		"reviews"
})
public class ReviewStatusListView {
	
	private String trackingNumber;
	private String dateRange = "";	//description of the date range

	private boolean displayTotals = false;

	private String totalDaysElapsed = "0.00";			//reviewer
	private String totalMedianDaysElapsed = "0.00";

	private String totalRequestorDaysElapsed = "0.00";	//requestor
	private String totalRequestorMedianDaysElapsed = "0.00";	
	
	@XmlElement(name="Review")
	List<ReviewStatusView> reviews = new ArrayList<ReviewStatusView>();
	
	
	public String getTrackingNumber() {
		return trackingNumber;
	}

	public void setTrackingNumber(String trackingNumber) {
		this.trackingNumber = trackingNumber;
	}

	
	public String getDateRange() {
		return dateRange;
	}

	public void setDateRange(String dateRange) {
		this.dateRange = dateRange;
	}

	
	public String getTotalDaysElapsed() {
		return totalDaysElapsed;
	}

	public void setTotalDaysElapsed(String totalDaysElapsed) {
		this.totalDaysElapsed = totalDaysElapsed;
	}

	public String getTotalMedianDaysElapsed() {
		return totalMedianDaysElapsed;
	}

	public void setTotalMedianDaysElapsed(String totalMedianDaysElapsed) {
		this.totalMedianDaysElapsed = totalMedianDaysElapsed;
	}

	public String getTotalRequestorDaysElapsed() {
		return totalRequestorDaysElapsed;
	}

	public void setTotalRequestorDaysElapsed(String totalRequestorDaysElapsed) {
		this.totalRequestorDaysElapsed = totalRequestorDaysElapsed;
	}

	public String getTotalRequestorMedianDaysElapsed() {
		return totalRequestorMedianDaysElapsed;
	}

	public void setTotalRequestorMedianDaysElapsed(
			String totalRequestorMedianDaysElapsed) {
		this.totalRequestorMedianDaysElapsed = totalRequestorMedianDaysElapsed;
	}
	

	public boolean isDisplayTotals() {
		return displayTotals;
	}

	public void setDisplayTotals(boolean displayTotals) {
		this.displayTotals = displayTotals;
	}

	
	public List<ReviewStatusView> getReviews() {
		return reviews;
	}
}
